/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.crud;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import java.util.stream.LongStream;
import org.codefilarete.stalactite.engine.crud.BatchUpdate;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.order.ColumnVariable;
import org.codefilarete.stalactite.sql.order.PlaceholderVariable;
import org.codefilarete.stalactite.sql.order.StatementVariable;
import org.codefilarete.stalactite.sql.order.Update;
import org.codefilarete.stalactite.sql.order.UpdateCommandBuilder;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.tool.collection.KeepOrderSet;

public class DefaultBatchUpdate<T extends Table<T>>
implements BatchUpdate<T> {
    private final Update<T> statement;
    private final Deque<Set<? extends StatementVariable<?, T>>> rows = new ArrayDeque();
    private final Dialect dialect;
    private final ConnectionProvider connectionProvider;
    private UpdateCommandBuilder.UpdateStatement<T> updateStatement;

    public DefaultBatchUpdate(Update<T> statement, Dialect dialect, ConnectionProvider connectionProvider) {
        this.statement = statement;
        this.dialect = dialect;
        this.connectionProvider = connectionProvider;
        this.rows.add(statement.getRow());
    }

    @Override
    public DefaultBatchUpdate<T> newRow() {
        this.rows.addLast((Set<StatementVariable<?, T>>)new KeepOrderSet());
        return this;
    }

    @Override
    public <C> DefaultBatchUpdate<T> set(Column<? extends T, C> column, C value) {
        this.assertColumnIsInUpdate(column);
        this.giveCurrentRow().add(new ColumnVariable<C, T>(column, value));
        return this;
    }

    @Override
    public <C> BatchUpdate<T> set(String paramName, C value) {
        this.giveCurrentRow().add(new PlaceholderVariable(paramName, value));
        return this;
    }

    private Set<StatementVariable<?, T>> giveCurrentRow() {
        return this.rows.getLast();
    }

    private <C> void assertColumnIsInUpdate(Column<? extends T, C> column) {
        if (!this.statement.getColumnsToUpdate().contains(column)) {
            throw new IllegalArgumentException("Column " + column + " is not defined in this batch update");
        }
    }

    @Override
    public long execute() {
        long[] writeCount;
        if (this.updateStatement == null) {
            this.updateStatement = new UpdateCommandBuilder<T>(this.statement, this.dialect).toStatement();
        }
        try (WriteOperation<T> writeOperation = this.dialect.getWriteOperationFactory().createInstance(this.updateStatement, this.connectionProvider);){
            this.rows.forEach(row -> {
                row.forEach(c -> {
                    if (c instanceof ColumnVariable) {
                        ((ColumnVariable)c).applyValueTo(this.updateStatement);
                    } else if (c instanceof PlaceholderVariable) {
                        ((PlaceholderVariable)c).applyValueTo(this.updateStatement);
                    }
                });
                writeOperation.addBatch(this.updateStatement.getValues());
            });
            writeCount = writeOperation.executeBatch();
        }
        this.rows.clear();
        this.rows.add((Set<StatementVariable<?, T>>)new KeepOrderSet());
        return LongStream.of(writeCount).sum();
    }
}

